#!/usr/bin/perl

use CGI::Carp qw(fatalsToBrowser);

## 目次をつける
$c{'FileIndex'} = 0;

## コメントを自動削除
$c{'CommentDisabled'} = 1;

## キャッシュ時間
## キャッシュが作成されて、以下の秒数未満の場合は
## ファイル更新を確認しません。
$c{'CacheWaitSec'} = 0;

## キャッシュファイルがある場合、更新を確認しない
## この設定を利用する場合はキャッシュファイル削除時に更新
$c{'CacheEnabled'} = 0;

#########################################################

my $name = $ENV{'QUERY_STRING'};
my @name = split(/\./,$ENV{'QUERY_STRING'});
my $type = $name[-1];
my $file = "";
pop @name;
if($name[-1] =~ /min/si){
	$c{'minifier'} = 1;
	pop @name;
	$file = join('.',@name);
	$c{'CachePath'} = "${file}.min.${type}";
}
else {
	$file = join('.',@name);
	$c{'CachePath'} = "${file}.${type}";
}

if(-d "./_${file}.${type}/"){
	if($type =~ /^css$/si){
		&_CSS("${file}.${type}");
	}
	else {
		&_JS("${file}.${type}");
	}
}
exit;
sub _CSS {
	my($filename) = @_;
	my $time = time;
	my $index = "";
	my $cd = "./_${filename}/";
	$CacheCreateTime = (stat $c{'CachePath'})[9];
	if($time < ($CacheCreateTime+$c{'CacheWaitSec'}) || $c{'CacheEnabled'}){
		$css = &_LOAD($c{'CachePath'});
	}
	else {
		my @stmp = ();
		my %css = ();
		opendir DH, $cd;
		while (my $file = readdir DH) {
			next if $file =~ /^\.{1,2}$/;
			if(-d "${cd}${file}" && !($file =~ /_.*?$/si)){
				push @media,"${file}";
				opendir CSS, "${cd}${file}/";
				while (my $data = readdir CSS) {
					if(!-d "${cd}${file}/${data}" && $data =~ /^.*?\.css$/si){
						$css{$file} .= ",${data}";
						push @stmp,(stat "${cd}${file}/${data}")[9];
					}
				}
				closedir CSS;
			}
		}
		closedir DH;
		push @stmp,(stat "./.replace.txt")[9];
		@stmp = sort {$b <=> $a} @stmp;
		if($stmp[0] > $CacheCreateTime){
			@media = sort { (split(/\./,$a))[1] <=> (split(/\./,$b))[1]} @media;
			for(my $i=0;$i<@media;$i++){
				my @css = split(/\,/,$css{$media[$i]});
				@css = sort {$a <=> $b} @css;
				my($media1,$size1,$media2,$size2) = split(/\./,$media[$i]);
				my($mediacss) = "";
				for(my $cnt=1;$cnt<@css;$cnt++){
					$index .= "\t${cd}${media[$i]}/${css[$cnt]}\n";
					$indexName = '';
					if($c{'FileIndex'}){
						$indexName = "/* // ${cd}${media[$i]}/${css[$cnt]} // */\n";
					}
					$mediacss .= $indexName . &_LOAD("${cd}${media[$i]}/${css[$cnt]}") . "\n";
				}
				if($size2){
					$mediacss = &_INDENT($mediacss);
					$css .= "\n\@media screen and (${media1}: ${size1}) and (${media2}: ${size2}){\n${mediacss}\n}\n";
				}
				elsif($size1){
					$mediacss = &_INDENT($mediacss);
					$css .= "\n\@media screen and (${media1}: ${size1}){\n${mediacss}\n}\n";
				}
				else {
					$css .= "\n${mediacss}\n";
				}
			}
			if($c{'minifier'}){
				$css = &_MINIFIER($css);
			}
			else {
				$css = &_CLEAN($css);
			}
			if($c{'FileIndex'}){
				$css = "/*\n${index}*/\n${css}";
			}
			if(-f "./.replace.txt"){
				my @rep = split(/\n/,&_LOAD("./.replace.txt"));
				for(my $i=1;$i<@rep;$i++){
					my($a,$b,$c,$d) = split(/\t/,$rep[$i]);
					if($c){
						$css =~ s/${a}/${b}/ig;
					}
				}
			}
			&_SAVE($c{'CachePath'},"\@charset \"UTF-8\";\n${css}");
		}
		else {
			$css = &_LOAD($c{'CachePath'});
		}
	}
	print "Content-type: text/css;charset=UTF-8\n\n";
	print $css;
}
sub _JS {
	my($filename) = @_;
	my $time = time;
	my $index = "";
	my $cd = "./_${filename}/";
	$CacheCreateTime = (stat $c{'CachePath'})[9];
	if($time < ($CacheCreateTime+$c{'CacheWaitSec'}) || $c{'CacheEnabled'}){
		$js = &_LOAD($c{'CachePath'});
	}
	else {
		my @stmp = ();
		my %js = ();
		my @js = ();
		opendir DH, $cd;
		while (my $file = readdir DH) {
			next if $file =~ /^\.{1,2}$/;
			if(!-d "${cd}${file}/" && $file =~ /^.*?\.js$/si && !($file =~ /^_.*?\.js$/si)){
				push @js,$file;
				push @stmp,(stat "${cd}${file}")[9];
			}
		}
		closedir DH;
		push @stmp,(stat "./.replace.txt")[9];
		@stmp = sort {$b <=> $a} @stmp;
		if($stmp[0] > $CacheCreateTime){
			@js = sort {$a <=> $b} @js;
			for(my $cnt=0;$cnt<@js;$cnt++){
				$js .= &_LOAD("${cd}/${js[$cnt]}") . "\n";
			}
			if($c{'minifier'}){
				$js = &_JSMINIFIER($js);
			}
			else {
				$js = &_JSCLEAN($js);
			}
			if(-f "./.replace.txt"){
				my @rep = split(/\n/,&_LOAD("./.replace.txt"));
				for(my $i=1;$i<@rep;$i++){
					my($a,$b,$c,$d) = split(/\t/,$rep[$i]);
					if($c){
						$js =~ s/${a}/${b}/ig;
					}
				}
			}
			&_SAVE($c{'CachePath'},$js);
		}
		else {
			$js = &_LOAD($c{'CachePath'});
		}
	}
	print "Content-type: text/javascript;charset=UTF-8\n\n";
	print $js;
}
sub _INDENT {
	my($str) = @_;
	if(!$c{'minifier'}){
		$str =~ s/\n\n/\n/ig;
		$str =~ s/\n$//ig;
		$str =~ s/\n/\n\t/ig;
		$str =~ s/\t$//ig;
		$str = "\t${str}";
	}
	return $str;
}
sub _MINIFIER {
	my($str) = @_;
	if($c{'CommentDisabled'}){
		$str =~ s/\/\*(.*?\*\/)//ig;
	}
	$str =~ s/\;\;/\;/ig;
	$str =~ s/\r/\n/ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\t//ig;
	$str =~ s/\: /\:/ig;
	$str =~ s/ \{/\{/ig;
	$str =~ s/\} /\}/ig;
	$str =~ s/^\n//ig;
	$str =~ s/\n//ig;
	return $str;
}
sub _CLEAN {
	my($str) = @_;
	if($c{'CommentDisabled'}){
		$str =~ s/\/\*(.*?\*\/)//ig;
	}
	$str =~ s/\t\n/\n/ig;
	$str =~ s/\t\n/\n/ig;
	$str =~ s/\;\;/\;/ig;
	$str =~ s/ \;/\;/ig;
	$str =~ s/\r/\n/ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\:/\:/ig;
	$str =~ s/\{/ \{/ig;
	$str =~ s/\} /\}/ig;
	$str =~ s/  / /ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\n\n/\n/ig;
	$str =~ s/\n\n/\n/ig;
	$str =~ s/\n\n/\n/ig;
	return $str;
}


sub _JSMINIFIER {
	my($str) = @_;
	while($str =~ /(^|\t|\n)\/\/(.*?)\n/si){
		$str =~ s/(^|\t|\n)\/\/(.*?)\n/\n/ig;
	}
	$str =~ s/\t\/\/(.*?)\n/\t\n/ig;
	$str =~ s/\n\/\/(.*?)\n/\n/ig;
	$str =~ s/^\/\/(.*?)\n//ig;
	$str =~ s/\r/\n/ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\t//ig;
	$str =~ s/\: /\:/ig;
	$str =~ s/ \{/\{/ig;
	$str =~ s/\} /\}/ig;
	$str =~ s/^\n//ig;
	$str =~ s/\n//ig;
	return $str;
}
sub _JSCLEAN {
	my($str) = @_;
	if($c{'CommentDisabled'}){
		while($str =~ /(^|\t|\n)\/\/(.*?)\n/si){
			$str =~ s/(^|\t|\n)\/\/(.*?)\n/\n/ig;
		}
	}
	while($str =~ / \t/si){
		$str =~ s/ \t/\t/ig;
	}
	while($str =~ /\t /si){
		$str =~ s/\t /\t/ig;
	}
	while($str =~ / \n/si){
		$str =~ s/ \n/\n/ig;
	}
	while($str =~ /\n /si){
		$str =~ s/\n /\n/ig;
	}
	while($str =~ /\t\n/si){
		$str =~ s/\t\n/\n/ig;
	}
	$str =~ s/\t\n/\n/ig;
	$str =~ s/\t\n/\n/ig;
	$str =~ s/\;\;/\;/ig;
	$str =~ s/ \;/\;/ig;
	$str =~ s/\r/\n/ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\n /\n/ig;
	$str =~ s/\:/\:/ig;
	$str =~ s/\{/ \{/ig;
	$str =~ s/\} /\}/ig;
	$str =~ s/  / /ig;
	$str =~ s/ \n/\n/ig;
	$str =~ s/\n /\n/ig;
	while($str =~ /\n\n/si){
		$str =~ s/\n\n/\n/ig;
	}
	return $str;
}

sub _SAVE {
	my($path,$str) = @_;
	chmod 0777, $path;
	flock(FH, LOCK_EX);
		open(FH,">${path}");
			print FH $str;
		close(FH);
	flock(FH, LOCK_NB);
	chmod 0644, $path;
}
sub _LOAD {
	my($path) = @_;
	flock(FH, LOCK_EX);
		open(FH,$path);
			@loader = <FH>;
		close(FH);
	flock(FH, LOCK_NB);
	$loader = join('',@loader);
	return $loader;
}
1;